#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>

#define MAX_N 1000000 

typedef struct {
    long long x;
    long long h;
    int originalIndex;
    double minDistance; 
} Jarbol;

int compareJarbol(const void *a, const void *b) {
    long long x_a = ((Jarbol*)a)->x;
    long long x_b = ((Jarbol*)b)->x;
    
    if (x_a < x_b) return -1;
    if (x_a > x_b) return 1;
    return 0;
}

int main() {
    setvbuf(stdout, NULL, _IONBF, 0); 

    int n;
    if (scanf("%d", &n) != 1) return 1;

    Jarbol *jarboli = (Jarbol*)malloc(n * sizeof(Jarbol));
    if (jarboli == NULL) return 1; 

    for (int i = 0; i < n; i++) {
        if (scanf("%lld", &jarboli[i].x) != 1) {
            free(jarboli);
            return 1;
        }
        jarboli[i].originalIndex = i;
        jarboli[i].minDistance = -1.0; 
    }

    for (int i = 0; i < n; i++) {
        if (scanf("%lld", &jarboli[i].h) != 1) {
            free(jarboli);
            return 1;
        }
    }

    qsort(jarboli, n, sizeof(Jarbol), compareJarbol);

    long long max_X_plus_H = LLONG_MIN;

    for (int j = 0; j < n; j++) {
        Jarbol *Pj = &jarboli[j];
        long long Mj = Pj->x + Pj->h; 

        if (max_X_plus_H != LLONG_MIN) {
            if (max_X_plus_H >= Mj) {
                double distance = (max_X_plus_H - Mj) / 2.0;
                
                if (Pj->minDistance == -1.0) {
                    Pj->minDistance = distance;
                } else {
                    Pj->minDistance = fmin(Pj->minDistance, distance);
                }
            }
        }

        max_X_plus_H = fmax(max_X_plus_H, Mj);
    }
    
    long long max_H_minus_X = LLONG_MIN;

    for (int j = n - 1; j >= 0; j--) {
        Jarbol *Pj = &jarboli[j];
        long long Mj_prime = Pj->h - Pj->x; 

        if (max_H_minus_X != LLONG_MIN) {
            if (max_H_minus_X >= Mj_prime) {
                double distance = (max_H_minus_X - Mj_prime) / 2.0;

                if (Pj->minDistance == -1.0) {
                    Pj->minDistance = distance;
                } else {
                    Pj->minDistance = fmin(Pj->minDistance, distance);
                }
            }
        }

        max_H_minus_X = fmax(max_H_minus_X, Mj_prime);
    }
    
    long long *results = (long long*)malloc(n * sizeof(long long));
    if (results == NULL) {
        free(jarboli);
        return 1;
    }

    for (int i = 0; i < n; i++) {
        if (jarboli[i].minDistance == -1.0) {
            results[jarboli[i].originalIndex] = -1;
        } else {
            results[jarboli[i].originalIndex] = (long long)round(jarboli[i].minDistance);
        }
    }

    for (int i = 0; i < n; i++) {
        printf("%lld\n", results[i]);
    }

    free(jarboli);
    free(results);

    return 0;
}